  #If 0
  =============================================================================
   Program NAME: UserDefinedLib.bas
   Author      : Eros Olmi
   Version     : 
   Description : DLL to test thinBasic loading library
  =============================================================================
  'COPYRIGHT AND PERMISSION NOTICE
  '============================================================================
  Copyright (c) 2003 - 2005, Eros Olmi, <eros.olmi@thinbasic.com>
   
  All rights reserved.
   
  Permission to use this software is granted only for the purpose to develop
  thinBasic language modules both for commercial or non commercial purpose.
  In any case the above copyright notice and this permission notice must appear
  in all copies.
   
  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  USE OR OTHER DEALINGS IN THE SOFTWARE.
  =============================================================================
  #EndIf

  #COMPILE DLL
  #REGISTER NONE
  #DIM ALL

  '---Resource file. Change UserDefinedLib.RC resource file as needed and remember to compile
  '   into UserDefinedLib.PBR file using resource compiler
  #RESOURCE "UserDefinedLib.PBR"
  
  #INCLUDE "WIN32API.INC"
  
  '---Every used defined thinBasic module must include this file
  #INCLUDE "thinCore.inc"

  '----------------------------------------------------------------------------
  FUNCTION Exec_HEX() AS STRING
  ' Return a string that is the hexadecimal (base 16) representation of its argument.
  ' Usage: s$ = HEX$(numeric_expression [, digits])
  '----------------------------------------------------------------------------
    LOCAL lNumber AS EXT
    LOCAL lDigits AS EXT

    '---Here we have to parse the syntax we have decided this new keyword will have
    '   Syntax is: an open pares
    '                followed by a numeric expression
    '                followed by an optional comma with an optional numeric expression
    '              a close parens
    '---Here how to do
    
    '---Parse open pares
    IF thinBasic_CheckOpenParens() THEN

      '---If ok, parse a numeric expression and return it's value.
      '   Remember to always use EXT numeric type even if you need a different one
      thinBasic_ParseNumber lNumber                                               

      '---Here we see if there is a comma.
      '   If not, we have instruct not to produce a runtime error and to put back
      '   the found token into the parsing stack
      IF thinBasic_CheckComma(%TRUE, %TRUE) THEN
      
        '---If optional comma was specified we parse another numeric expression
        thinBasic_ParseNumber lDigits                                          
        
      END IF
        
        '---At the end check if close parens was specified
        IF thinBasic_CheckCloseParens() THEN

          '---At the end here we are. If optional parameter was specified, call the function
          '   with the optional parameter
          IF lDigits > 0 THEN
            FUNCTION = HEX$(lNumber, lDigits)
          ELSE                           
            
            '---otherwise call function without optional parameter
            FUNCTION = HEX$(lNumber)
        END IF                      
        
      END IF
      
    END IF
    
  END FUNCTION

  '----------------------------------------------------------------------------
  FUNCTION Exec_Console_FColor() AS EXT
  ' Compose a new console foreground color.
  ' Usage: n = Console_fColor ( R AS LONG, G AS LONG, B AS LONG, Intense AS LONG)
  '----------------------------------------------------------------------------
    LOCAL R         AS EXT, lR        AS LONG
    LOCAL G         AS EXT, lG        AS LONG
    LOCAL B         AS EXT, lB        AS LONG
    LOCAL Intense   AS EXT, lIntense  AS LONG
    LOCAL ForeColor AS LONG

    IF thinBasic_CheckOpenParens() THEN
      thinBasic_ParseNumber R
      IF thinBasic_CheckComma() THEN
        thinBasic_ParseNumber G
        IF thinBasic_CheckComma() THEN
          thinBasic_ParseNumber B
          IF thinBasic_CheckComma() THEN
            thinBasic_ParseNumber Intense
            IF thinBasic_CheckCloseParens() THEN
              lR = R
              lG = G
              lB = B
              lIntense = Intense

              IF lR       THEN ForeColor =              %FOREGROUND_RED 
              IF lG       THEN ForeColor = ForeColor OR %FOREGROUND_GREEN 
              IF lB       THEN ForeColor = ForeColor OR %FOREGROUND_BLUE
              IF lIntense THEN ForeColor = ForeColor OR %FOREGROUND_INTENSITY 

              FUNCTION = ForeColor
            END IF
          END IF
        END IF
      END IF
    END IF
    
  END FUNCTION 
  
  
  '----------------------------------------------------------------------------
  FUNCTION LoadLocalSymbols ALIAS "LoadLocalSymbols" (OPTIONAL BYVAL sPath AS STRING) EXPORT AS LONG
  ' This function is automatically called by thinCore whenever this DLL is loaded.
  ' This function MUST be present in every external DLL you want to use
  ' with thinBasic
  ' Use this function to initialize every variable you need and for loading the
  ' new symbol (read Keyword) you have created.
  '----------------------------------------------------------------------------

    '---
    'Add here Initialization code if needed
    '---

    
    '---
    'Here define/add new thinBasic keywords
    '---                                     
    '---Here an example. Defined a new keyword named HEX$ which will return a string.
    '   Connect this keyword with Exec_HEX internal function passing its pointer with CODEPTR.
    '   Last parameter tells thinBasic that even if HEX$ keyword has already been defined, this new
    '   definition will have priority and will overwite previous keyword configuration
    thinBasic_LoadSymbol "MyHEX$",                      %thinBasic_ReturnString,      CODEPTR(Exec_HEX),              %thinBasic_ForceOverWrite
    thinBasic_LoadSymbol "Console_fColor",              %thinBasic_ReturnNumber,      CODEPTR(Exec_Console_FColor),   %thinBasic_ForceOverWrite


    '---
    'Here define/add new thinBasic equates
    '---
    thinBasic_AddEquate  "%MyNumericEquate",             ""       , 1
    thinBasic_AddEquate  "$MyStringEquate",              "ABC"    , 0
    


  END FUNCTION

  '----------------------------------------------------------------------------
  FUNCTION UnLoadLocalSymbols ALIAS "UnLoadLocalSymbols" () EXPORT AS LONG
  ' This function is automatically called by thinCore whenever this DLL is unloaded.
  ' This function CAN be present but it is not necessary. If present, this function
  ' will be executed by thinBasic core when module will be released.
  ' Use this function to perform uninitialize process, if needed.
  '----------------------------------------------------------------------------

    '---
    'Add here DeInitialization code if needed
    '---

    FUNCTION = 0&
  END FUNCTION


  FUNCTION LIBMAIN ALIAS "LibMain" (BYVAL hInstance   AS LONG, _
                                    BYVAL fwdReason   AS LONG, _
                                    BYVAL lpvReserved AS LONG) EXPORT AS LONG
    SELECT CASE fwdReason
      CASE %DLL_PROCESS_ATTACH

        FUNCTION = 1
        EXIT FUNCTION
      CASE %DLL_PROCESS_DETACH

        FUNCTION = 1
        EXIT FUNCTION
      CASE %DLL_THREAD_ATTACH
      
        FUNCTION = 1
        EXIT FUNCTION
      CASE %DLL_THREAD_DETACH
      
        FUNCTION = 1
        EXIT FUNCTION
    END SELECT 
    
  END FUNCTION
